define([
    'underscore',
    'backbone',
    'json!modules/new-appointment-request/resources/common/city-state/state-hash.json',
], function(_, Backbone, stateHash) {
    'use strict';


    /**
     * @class CityStateModel
     * @typedef {Backbone.Model}
     */
    return Backbone.Model.extend({
        idAttribute: 'institutionCode',

        /**
         * @param {CityStateModel} model
         * @return {number} 1, 0 , -1
         */
        compare: function(model) {
            var myState = this.get('stateAbbrev') || '';
            var theirState = model.get('stateAbbrev') || '';
            var stateCompare = myState.localeCompare(theirState);

            var myCity;
            var theirCity;

            if (stateCompare) {
                return stateCompare;
            }

            myCity = this.get('city') || '';
            theirCity = model.get('city') || '';
            return myCity.localeCompare(theirCity);

        },

        /**
         * Generates the city state string:
         * City, ST
         * City
         * ST
         * @return {string}
         */
        toString: function() {
            var city = this.get('city');
            var state = this.get('stateAbbrev');
            return _.compact([city, state]).join(', ');
        },

        /**
         * Gets the full state name
         * @return {string}
         */
        getStateName: function() {
            var abbreviation = this.get('stateAbbrev');
            if (stateHash.hasOwnProperty(abbreviation)) {
                return stateHash[abbreviation];
            }
            return abbreviation;
        },
    });
});
